<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <link rel="icon" type="image/png" href="assets/img/favicon.ico">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />

    <title>Kharsiya - Voters Dataset</title>

    <meta content='width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0' name='viewport' />
    <meta name="viewport" content="width=device-width" />


    <!-- Bootstrap core CSS     -->
    <link href="<?php echo e(url('/')); ?>/css/bootstrap.min.css" rel="stylesheet" />

    <!-- Animation library for notifications   -->
    <link href="<?php echo e(url('/')); ?>/css/animate.min.css" rel="stylesheet"/>

    <!--  Light Bootstrap Table core CSS    -->
    <link href="<?php echo e(url('/')); ?>/css/light-bootstrap-dashboard.css?v=1.4.0" rel="stylesheet"/>

    <!--     Fonts and icons     -->
    <link href="http://maxcdn.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css" rel="stylesheet">
    <link href='http://fonts.googleapis.com/css?family=Roboto:400,700,300' rel='stylesheet' type='text/css'>
    <link href="<?php echo e(url('/')); ?>/css/pe-icon-7-stroke.css" rel="stylesheet" />

    <link rel="stylesheet" href="<?php echo e(url('/')); ?>/css/custom.css">

    <link rel="stylesheet" href="<?php echo e(url('/')); ?>/css/select2.css">

    <script src="<?php echo e(url('/')); ?>/js/jquery.3.2.1.min.js" type="text/javascript"></script>

</head>
<body>

<div class="wrapper">
    <div class="sidebar" data-color="green" data-image="<?php echo e(url('/')); ?>/img/sidebar-5.jpg">

        <div class="sidebar-wrapper">
            <div class="logo">
                <a href="http://www.creative-tim.com" class="simple-text">
                    Kharsiya
                </a>
            </div>

            <ul class="nav">
                <li class="
                <?php if(Request::url() === url('/')): ?>
                    active
                <?php endif; ?>
                ">
                    <a href="<?php echo e(url('/')); ?>">
                        <i class="pe-7s-graph"></i>
                        <p>Dashboard</p>
                    </a>
                </li>
                <li class="
                <?php if(Request::url() === url('/booth')): ?>
                    active
                <?php endif; ?>
                ">
                    <a href="booth">
                        <i class="pe-7s-graph3"></i>
                        <p>Poling Booths</p>
                    </a>
                </li>
                <li class="
                <?php if(Request::url() === url('/ageWise')): ?>
                    active
                <?php endif; ?>
                ">
                    <a href="ageWise">
                        <i class="pe-7s-users"></i>
                        <p>Age wise list</p>
                    </a>
                </li>
                <li class="
                <?php if(Request::url() === url('/cast')): ?>
                    active
                <?php endif; ?>
                ">
                    <a href="cast">
                        <i class="pe-7s-ticket"></i>
                        <p>Cast wise list</p>
                    </a>
                </li>
                <li class="
                <?php if(Request::url() === url('/advance')): ?>
                    active
                <?php endif; ?>
                ">
                    <a href="advance">
                        <i class="pe-7s-tools"></i>
                        <p>Advanced Search</p>
                    </a>
                </li>
                <li class="
                <?php if(Request::url() === url('/families')): ?>
                    active
                <?php endif; ?>
                ">
                    <a href="families">
                        <i class="pe-7s-users"></i>
                        <p>Families</p>
                    </a>
                </li>
            </ul>
        </div>
    </div>

    <div class="main-panel">
        <nav class="navbar navbar-default navbar-fixed">
            <div class="container-fluid">
                <div class="navbar-header">
                    <button type="button" class="navbar-toggle" data-toggle="collapse">
                        <span class="sr-only">Toggle navigation</span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                        <span class="icon-bar"></span>
                    </button>
                    <a class="navbar-brand" href="#">Indian National Congress, Chhattisgrah</a>
                </div>
                <div class="collapse navbar-collapse">
                    <ul class="nav navbar-nav navbar-left">
                        <li>
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                <i class="fa fa-dashboard"></i>
                            </a>
                        </li>
                    </ul>

                    <ul class="nav navbar-nav navbar-right">
                        <li>
                           <a href="<?php echo e(url('/logout')); ?>">
                               Logout
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>


        <div class="content">
            <div class="container-fluid">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </div>


        <footer class="footer">
            <div class="container-fluid">
                <nav class="pull-left">
                    <ul>
                        <li>
                            <a href="#">
                                Home
                            </a>
                        </li>

                    </ul>
                </nav>
                <p class="copyright pull-right">
                   Kharsiya Constituency - Voters dataset
                </p>
            </div>
        </footer>

    </div>
</div>


    <!--   Core JS Files   -->
    <script src="<?php echo e(url('/')); ?>/js/bootstrap.min.js" type="text/javascript"></script>

    <!--  Charts Plugin -->
    <script src="<?php echo e(url('/')); ?>/js/chartist.min.js"></script>

    <!--  Notifications Plugin    -->
    <script src="<?php echo e(url('/')); ?>/js/bootstrap-notify.js"></script>

    <!--  Google Maps Plugin    -->
    <!-- <script type="javascript" src="https://maps.googleapis.com/maps/api/js?key=YOUR_KEY_HERE"></script> -->

    <!-- Light Bootstrap Table Core javascript and methods for Demo purpose -->
    <script src="<?php echo e(url('/')); ?>/js/light-bootstrap-dashboard.js?v=1.4.0"></script>

    <!-- Light Bootstrap Table DEMO methods, don't include it in your project! -->
    <script src="<?php echo e(url('/')); ?>/js/demo.js"></script>

    <script src="<?php echo e(url('/')); ?>/js/select2.js"></script>


    <script>
        $(function (argument) {
            $('select').select2();
        });
    </script>


    <script>
        $(function () {

            // For geting anubhag selection from booth
            $('#booth').on('select2:select', function (e) {
                // Get Booth ID
                var id = e.params.data.id;

                // Disable Anubhag seelect
                $('#anubhag').prop('disabled', 'disabled');

                // Get Anubhag data 
                $.get("<?php echo e(url('/')); ?>/getAnubhag/boothId/"+id,function($data){

                    // Prse Json data
                    $data = JSON.parse($data)

                    // Logging data to console
                    console.log();

                    //select anubhag field
                    var $select = $('#anubhag');

                    //Clear already existing options
                    var select = document.getElementById("anubhag");
                    for(i = select.options.length - 1 ; i >= 0 ; i--)
                    {
                        select.remove(i);
                    }

                    var $option = $("<option/>").attr("value", 0).text('Select Anubhag');
                    $select.append($option);

                    // Append select field
                    $($data).each(function (index, o) {    
                        var $option = $("<option/>").attr("value", o.id).text(o.name);
                        $select.append($option);
                    });
                })

                // Activate Anubhag field
                $('#anubhag').prop('disabled', false);
            });
        });
    </script>


    <script>
        $(function(){
            str = window.location.href;
            str1 = str.split('?')[0];

            excel = str.replace('families','excel/families');
            excel = excel.replace('advance','excel/advance');
            excel = excel.replace('cast','excel/cast');
            excel = excel.replace('ageWise','excel/ageWise');
            excel = excel.replace('booth','excel/booth');

            document.getElementById('excel').href = excel

            if(str.includes('booth') || str.includes('advance') || str.includes('cast') || str.includes('ageWise') || str.includes('families')){
                elementArray = document.getElementsByClassName('page-link');
                for(var i = 0; i < elementArray.length; i++){
                    if(elementArray[i].nodeName == "A"){
                        url = elementArray[i].href;
                        url = url.replace('?','&');
                        url = url.replace(str1,str);
                        elementArray[i].href = url;
                    }
                }
            }


           

        });
    </script>

</body>



</html>