@extends('layout')

@section('content')

<form action="{{url('/')}}/families" method="get">

	<div class="row">
		<div class="col-md-5">
			<h4>Select Booth Name</h4>
			<select name="booth" class="form-control" id="booth">
				<option value="0" selected="selected">Select Booth</option>
				@foreach($booths as $booth)
					<option value="{{$booth->id}}">{{$booth->name}}</option>
				@endforeach
			</select>
		</div>
		<div class="col-md-5">
			<h4>Select Anubhag Name</h4>
			<select name="anubhag" class="form-control" id="anubhag">
			</select>
		</div>
		<div class="col-md-2">
			<h4>Family Size</h4>
			<input type="number" value="4" required="required" name="familySize" class="form-control">
		</div>
	</div>

	<br>
	
	<div class="row">
		<div class="col-md-12">
			<input type="submit" name="submit" value="submit" value="Run Querry" class="form-control" style="background-color: #8CBF4E; color: white">
		</div>
	</div>
	
</form>


<hr>

<div class="row">
	<div class="col-md-12">
		<h2>
			People with more then 4 dependants
			@if(isset($count))
			 (Total {{$count}} Results)
			@endif
		</h2>
		<table style="width: 100%;">
			<thead>
				<th>
					Name
				</th>
				<th>
					Anubhag Name
				</th>
				<th>
					Booth Name
				</th>
				<th>
					Number of dependants
				</th>
			</thead>
			<tbody>
				@if( ! empty($voters))
					@foreach($voters as $voter)
						<tr>
							<td>
								{{$voter->fathersName}}
							</td>
							<td>
								@if($voter->anubhagId != 5000)
									@if(NULL !== App\anubhag::find($voter->anubhagId))
										{{App\anubhag::find($voter->anubhagId)->name}}
									@endif
								@endif
							</td>
							<td>
								@if($voter->anubhagId != 5000)
									@if(NULL !== App\anubhag::find($voter->anubhagId))
									{{App\booth::find(App\anubhag::find($voter->anubhagId)->boothId)->name}}
									@endif
								@endif
							</td>
							<td>
								{{$voter->ct}}
							</td>
						</tr>
					@endforeach
				@endif
			</tbody>
		</table>
	</div>
</div>

@endsection


