@extends('layout')

@section('content')


<div class="row">

	<div class="col-md-4">
		<div class="card">
			<h3>Total Voters</h3>
			<h1>
				{{$all}} <span class="pe-7s-users"></span>
			</h1>
		</div>
	</div>
	<div class="col-md-4">
		<div class="card">
			<h3>Total Male Voters</h3>
			<h1>
				{{$male}} <span class="pe-7s-user"></span>
			</h1>
		</div>
	</div>
	<div class="col-md-4">
		<div class="card">
			<h3> Total Female Voters</h3>
			<h1>
				{{$female}} <span class="pe-7s-user-female"></span>
			</h1>
		</div>
	</div>

</div>

<div class="row">
	<div class="col-md-12">
		<h2>Booth Overview</h2>

		<table>
			<thead>
				<th>
					Booth Name 
				</th>
				<th>
					Total Voters
				</th>
				<th>
					Male Voters
				</th>
				<th>
					Female Voters
				</th>
			</thead>
			<tbody>
				@foreach($booths as $booth)
				<tr>
					<td>
						{{$booth->name}}
					</td>
					<td>
						{{$booth->count()}}
					</td>
					<td>
						{{$booth->male()}}
					</td>
					<td>
						{{$booth->female()}}
					</td>
				</tr>
				@endforeach
			</tbody>
		</table>
	</div>
</div>

<div class="row">
	<div class="col-md-6">
		{{$booths->links()}}
	</div>
	<div class="col-md-6">
		<a href="{{url('/')}}/excel" class="btn btn-success" style="float: right;">Download Excel</a>
	</div>	
</div>


@endsection