@extends('layout')

@section('content')

@if (session('response'))
    <div class="alert alert-success">
        {{ session('response') }}
    </div>
@endif

<form action="{{url('/')}}/booth" method="get">

	<div class="row">
		<div class="col-md-6">
			<h4>Select Booth Name</h4>
			<select name="booth" class="form-control" id="booth">
				<option value="0" selected="selected">Select Booth</option>
				@foreach($booths as $booth)
					<option value="{{$booth->id}}">{{$booth->id}} - {{$booth->name}}</option>
				@endforeach
			</select>
		</div>
		<div class="col-md-6">
			<h4>Select Anubhag Name</h4>
			<select name="anubhag" class="form-control" id="anubhag">
			</select>
		</div>
	</div>

	<br>
	
	<div class="row">
		<div class="col-md-12">
			<input type="submit" name="submit" value="submit" value="Run Querry" class="form-control" style="background-color: #8CBF4E; color: white">
		</div>
	</div>
	
</form>


<hr>

<div class="row">
	<div class="col-md-12">
		<h1>
			Result Table  
			@if(isset($count))
			 (Total {{$count}} Results)
			@endif
		</h1>
		<table style="width: 100%;">
			<thead>
				<th>
					Voter ID
				</th>
				<th>
					First Name
				</th>
				<th>
					Last Name
				</th>
				<th>
					Father's Name
				</th>
				<th>
					House No
				</th>
				<th>
					Age
				</th>
				<th>
					Gender
				</th>
				<th>
					Anubhag
				</th>
				<th>
					Booth
				</th>
				<th>
					Action
				</th>
			</thead>
			<tbody>
				@if( ! empty($voters))
					@foreach($voters as $voter)
						<tr>
							<td>
								{{$voter->voterId}}
							</td>
							<td>
								{{$voter->name}}
							</td>
							<td>
								{{$voter->lastName}}
							</td>
							<td>
								{{$voter->fathersName}}
								{{$voter->husbandsName}}
								{{$voter->mothersName}}
							</td>
							<td>
								{{$voter->houseNo}}
							</td>
							<td>
								{{$voter->age}}
							</td>
							<td>
								{{$voter->gender}}
							</td>
							<td>
								{{$voter->anubhag()}}
							</td>
							<td>
								{{$voter->booth()}}
							</td>
							<td>
								<a href="{{url('/delete',$voter->id)}}" class="btn btn-danger">
									Delete
								</a>
							</td>
						</tr>
					@endforeach
				@endif
			</tbody>
		</table>
	</div>
</div>

<br>

@if( ! empty($voters))
<div class="row">
	<div class="col-md-6">
		{{$voters->links()}}
	</div>
	<div class="col-md-6">
		<a href="" class="btn btn-success" id="excel" style="float: right;">Download Excel</a>
	</div>	
</div>
@endif

@endsection


