@extends('layout')

@section('content')

@if (session('response'))
    <div class="alert alert-success">
        {{ session('response') }}
    </div>
@endif

<form action="{{url('/')}}/ageWise" method="get">

	<div class="row">
		<div class="col-md-12">
			<div class="row">
				<div class="col-md-8" >
					<h4>
						Age Range
					</h4>
					<div class="row">
						<div class="col-md-6">
							Minimum Limit
							<input type="number" name="ageMin" placeholder="Range Minimum" class="form-control">
						</div>
						<div class="col-md-6">
							Maximum Limit
							<input type="number" name="ageMax" placeholder="Range Maximum" class="form-control">
						</div>
					</div>
				</div>
				<div class="col-md-4">
					<h4>
						Exact Age
					</h4>
					<div class="row">
						Search for eaxact age match (overrides age range)
						<div class="col-md-12">
							<input type="number" name="ageExact" placeholder="Exact Age" class="form-control">
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<br>
	<div class="row">
		<div class="col-md-12">
			<input type="submit" name="submit" value="submit" value="Run Querry" class="form-control" style="background-color: #8CBF4E; color: white">
		</div>
	</div>
	
</form>


<hr>

<div class="row">
	<div class="col-md-12">
		<h1>
			Result Table  
			@if(isset($count))
			 (Total {{$count}} Results)
			@endif
		</h1>
		<table style="width: 100%;">
			<thead>
				<th>
					Voter ID
				</th>
				<th>
					First Name
				</th>
				<th>
					Last Name
				</th>
				<th>
					Father's Name
				</th>
				<th>
					House No
				</th>
				<th>
					Age
				</th>
				<th>
					Gender
				</th>
				<th>
					Anubhag
				</th>
				<th>
					Booth
				</th>
				<th>
					Action
				</th>
			</thead>
			<tbody>
				@if( ! empty($voters))
					@foreach($voters as $voter)
						<tr>
							<td>
								{{$voter->voterId}}
							</td>
							<td>
								{{$voter->name}}
							</td>
							<td>
								{{$voter->lastName}}
							</td>
							<td>
								{{$voter->fathersName}}
								{{$voter->husbandsName}}
								{{$voter->mothersName}}
							</td>
							<td>
								{{$voter->houseNo}}
							</td>
							<td>
								{{$voter->age}}
							</td>
							<td>
								{{$voter->gender}}
							</td>
							<td>
								{{$voter->anubhag()}}
							</td>
							<td>
								{{$voter->booth()}}
							</td>
							<td>
								<a href="{{url('/delete',$voter->id)}}" class="btn btn-danger">
									Delete
								</a>
							</td>
						</tr>
					@endforeach
				@endif
			</tbody>
		</table>
	</div>
</div>

<br>

@if( ! empty($voters))
<div class="row">
	<div class="col-md-6">
		{{$voters->links()}}
	</div>
	<div class="col-md-6">
		<a href="" class="btn btn-success" id="excel" style="float: right;">Download Excel</a>
	</div>	
</div>
@endif

@endsection


