<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\voter;
use App\booth;
use App\anubhag;
use Rap2hpoutre\FastExcel\FastExcel;


class excelController extends Controller
{

	public function __construct()
    {
        $this->middleware('auth');
    }


    public function show(){
		


		$booths = booth::all();

		foreach ($booths as $booth) {
			$booth['Total Voters'] = $booth->count();
			$booth['Male Voters'] = $booth->male();
			$booth['Female Voters'] = $booth->female();			
		}

		(new FastExcel($booths))->export('booths.xlsx');

		return redirect(url('/booths.xlsx'));

	}


	public function anubhagList($id){
		$anubhags = anubhag::where('boothId','=',$id)->get()->toJson();
		return $anubhags;
	}


	public function advance(Request $request){

		if(! isset($request->submit)){
			$booths = booth::all();
			return view('advance')->with(['booths'=>$booths]);
		}
		
		else{
			// Anubhag
			if($request->anubhag){
				$voters = voter::where('anubhagId','=',$request->anubhag);
			}elseif($request->booth){
				$voters = voter::whereIn('anubhagId',booth::find($request->booth)->anubhags());
			}else{
				$voters = voter::where('id','>','-1');
			}

			// Gender
			if(isset($request->gender)){
				$voters = $voters->where('gender','=',$request->gender);
			}

			// Age
			if(isset($request->ageExact)){

				// Exact
				$voters = $voters->where('age','=',$request->ageExact);

			}else{

				// Range
				if(isset($request->ageMin)){
					$voters = $voters->where('age','>',$request->ageMin);
				}

				if(isset($request->ageMax)){
					$voters = $voters->where('age','<',$request->ageMax);
				}
			}

			if(isset($request->lastName)){
				$voters = $voters->where('lastName','like',$request->lastName)
					->orWhere('fathersName','like',$request->lastName);
				// 	->orWhere('husbandsName','like',$request->lastName)
				// 	->orWhere('mothersName','like',$request->lastName)
			}

			$voters = $voters->get();

			foreach ($voters as $voter) {
				$voter['anubhag'] = $voter->anubhag();
				$voter['booth'] = $voter->booth();
			}

			(new FastExcel($voters))->export('voters.xlsx');

			return redirect(url('/voters.xlsx'));

		}

	}

	public function booth(Request $request){

		if(! isset($request->submit)){
			$booths = booth::all();
			return view('booth')->with(['booths'=>$booths]);
		}
		
		else{
			// Anubhag
			if($request->anubhag){
				$voters = voter::where('anubhagId','=',$request->anubhag);
			}elseif($request->booth){
				$voters = voter::whereIn('anubhagId',booth::find($request->booth)->anubhags());
			}else{
				$voters = voter::where('id','>','-1');
			}

			$voters = $voters->get();

			foreach ($voters as $voter) {
				$voter['anubhag'] = $voter->anubhag();
				$voter['booth'] = $voter->booth();
			}

			(new FastExcel($voters))->export('voters.xlsx');

			return redirect(url('/voters.xlsx'));

		}

	}



	public function age(Request $request){
		
		if(isset($request->ageExact)){

			// Exact
			$voters = voter::where('age','=',$request->ageExact);

		}else{

			// Range
			if(isset($request->ageMin)){
				$voters = voter::where('age','>',$request->ageMin);
			}

			if(isset($request->ageMax)){
				$voters = voter::where('age','<',$request->ageMax);
			}
		}


		$voters = $voters->get();

		foreach ($voters as $voter) {
			$voter['anubhag'] = $voter->anubhag();
			$voter['booth'] = $voter->booth();
		}

		(new FastExcel($voters))->export('voters.xlsx');

		return redirect(url('/voters.xlsx'));

	}



	public function cast(Request $request){

		if(! isset($request->submit)){
			$booths = booth::all();
			return view('cast')->with(['booths'=>$booths]);
		}
		
		else{
			
		
			if(isset($request->lastName)){
				$voters = voter::where('lastName','like',$request->lastName)
					->orWhere('fathersName','like',$request->lastName);
				// 	->orWhere('husbandsName','like',$request->lastName)
				// 	->orWhere('mothersName','like',$request->lastName)
			}

			$count = $voters->count();
			$male = $voters->where('gender', '=', 'Male')->count();
			$female = $voters->where('gender', '=', 'Female')->count();
			$voters = $voters->get();

			foreach ($voters as $voter) {
				$voter['anubhag'] = $voter->anubhag();
				$voter['booth'] = $voter->booth();
			}

			(new FastExcel($voters))->export('voters.xlsx');

			return redirect(url('/voters.xlsx'));
		}

	}


	public function families(Request $request){

		if(! isset($request->submit)){
			$booths = booth::all();
			return view('families')->with(['booths'=>$booths]);
		}
		
		else{

			if($request->anubhag){
				$voters = DB::select("select * from (SELECT COUNT(id) as ct, fathersName, anubhagId FROM voters WHERE fathersName != '' and anubhagId = ".$request->anubhag." GROUP BY fathersName, anubhagId ORDER BY COUNT(id) DESC) as tb where tb.ct > ".($request->familySize - 1));
			}elseif ($request->booth){
				$voters = DB::select("select * from (SELECT COUNT(id) as ct, fathersName, anubhagId FROM voters WHERE fathersName != '' and anubhagId in (".implode(',',booth::find($request->booth)->anubhags()).") GROUP BY fathersName, anubhagId ORDER BY COUNT(id) DESC) as tb where tb.ct > ".($request->familySize - 1));
			}else{
				$voters = DB::select("select * from (SELECT COUNT(id) as ct, fathersName, anubhagId FROM voters WHERE fathersName != '' GROUP BY fathersName, anubhagId ORDER BY COUNT(id) DESC) as tb where tb.ct > ".($request->familySize - 1));
			}
			
			$booths = booth::all();

			return view('families')->with(['voters'=>$voters, 'booths'=>$booths]);

		}

	}
}
